function [overV, aveV, underV] = VolumeEstimate(filename, maxrange, steplength)

    Scan = dlmread(filename,' ');
    g = find(Scan(:,3) < maxrange);
    
    [X,Y,Z] = sph2cart(-Scan(g,1), Scan(g,2)-pi/2, Scan(g,3));
    Xoff = min(X);
    Yoff = min(Y);
    Zoff = min(Z);
    
    X = X - Xoff;
    Y = Y - Yoff;
    Z = Z - Zoff;
    
    figure(1);plot(X,Y,'.');
    pause
    figure(1);plot(X,Z,'.');
    pause
    figure(1);plot(Y,Z,'.');
    pause
    
    minZ = min(Z)
    maxZ = max(Z)
    max(Scan(:,3))
    
    inc = (maxZ-minZ)/steplength;
    
    TotalVolumeOver = 0;
    TotalVolumeAve = 0;
    TotalVolumeUnder = 0;
    
    for i=0:steplength-1
        pts1 = find(Z >= minZ+i*inc & Z < minZ+(i+1)*inc);
        vx = X(pts1); vy = Y(pts1);
        
        figure(1); plot(vx,vy,'.'); hold on;
        
        minY = min(vy); maxY = max(vy);
        yinc = (maxY - minY)/20;
        
        TotalArea = 0;
        ConfidenceCount = 1;
        
        for j=0:20-1
            pts2 = find(vy >= minY+j*yinc & vy < minY+(j+1)*yinc);
            vxx = vx(pts2);
            minX = min(vxx);
            maxX = max(vxx);
            
            if(length(minX) ~= 0)
                 figure(1);plot([minX; maxX],ones(1,2)*minY+(j+1)*yinc,'-g');
                 TotalArea = TotalArea + yinc*(maxX-minX);
                 
                 if(maxX - minX) > 1
                     ConfidenceCount = ConfidenceCount + 1;
                 end
            end
                figure(1);plot(vxx,ones(1,length(vxx))*minY+j*yinc,'rX');
        end
        [K,a] = convhull(X(pts1),Y(pts1));
        figure(1); plot(vx(K), vy(K),'p-'); pause
        
        TotalVolumeOver = TotalVolumeOver + inc * a;
        TotalVolumeUnder = TotalVolumeUnder + TotalArea*inc;
        
        WeightedArea = (ConfidenceCount/20)*TotalArea + (1-(ConfidenceCount/20))*a ;
        TotalVolumeAve = TotalVolumeAve +  WeightedArea*inc;
        hold off;
        
    end
    
    overV = TotalVolumeOver
    aveV = TotalVolumeAve
    underV = TotalVolumeUnder
    
    